﻿#include "pch.h"
#include "framework.h"
#include "NSeries_SDK_USB_ETH.h"
#include "NSeries_SDK_USB_ETHDlg.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif
#define WM_UIUPDATE WM_USER +1
enum PIXELINFOMATION
{
	SP_SM245N_REALPIXEL = 2080,
    SP_SM245N_EFFECTIVEPIXEL = 2048
};

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

#ifdef AFX_DESIGN_TIME
	enum { IDD = IDD_ABOUTBOX };
#endif
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    
protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(IDD_ABOUTBOX)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


CNSERIESSDKUSBETHDlg::CNSERIESSDKUSBETHDlg(CWnd* pParent /*=nullptr*/)
	: CDialogEx(IDD_NSeries_SDK_USB_ETH_DIALOG, pParent)
	, m_Dataname(_T(""))
	, m_dIntTime(0)
	, m_bAutoDark(FALSE)
	, m_bRunOutTrg(FALSE)
	, m_sSelOutTrgPin(0)
	, m_sOutTrgDelay(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CNSERIESSDKUSBETHDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	//  DDX_Text(pDX, IDC_EDIT_INTTIME, m_lIntTime);
	DDX_Text(pDX, IDC_EDIT_TIMEAVERAGE, m_iTimeAve);
	DDX_Control(pDX, IDC_EDIT_INTTIME, m_edIntTime);
	DDX_Control(pDX, IDC_EDIT_TIMEAVERAGE, m_edTimeAve);
	DDX_Control(pDX, IDC_CHK_FREERUN_NEXT, m_rbtrgNext);
	DDX_Control(pDX, IDC_CHK_FREERUN_PREV, m_rbtrgPrevious);
	DDX_Control(pDX, IDC_CHK_SWTRIGGER, m_rbtrgSW);
	DDX_Control(pDX, IDC_CHK_EXTERNAL_TRIGGER, m_rbtrgExternal);
	DDX_Control(pDX, IDC_BTN_APPLY, m_btnApply);
	DDX_Control(pDX, IDC_LIST_DEVICE, m_Devicelist);
	DDX_Control(pDX, IDC_EDIT_DATANAME, m_eddataname);
	DDX_Text(pDX, IDC_EDIT_DATANAME, m_Dataname);
	DDX_Control(pDX, IDC_BTN_CONNECT, m_btnConnect);
	DDX_Control(pDX, IDC_BTN_GETDATA, m_btnGetdata);
	DDX_Control(pDX, IDC_BTN_DEVCLOSE, m_btnDevClose);
	DDX_Text(pDX, IDC_EDIT_INTTIME, m_dIntTime);
	DDX_Check(pDX, IDC_CHK_AUTODARK, m_bAutoDark);
	DDX_Check(pDX, IDC_CHK_RUNOUTPUTTRIGGER, m_bRunOutTrg);
	DDX_Text(pDX, IDC_EDIT_SELOUTTRGPIN, m_sSelOutTrgPin);
	DDX_Text(pDX, IDC_EDIT_OUTTRGDELAY, m_sOutTrgDelay);
	DDX_Control(pDX, IDC_BTN_EXTAPPLY, m_btnExtApply);
}

BEGIN_MESSAGE_MAP(CNSERIESSDKUSBETHDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_CONNECT, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnConnect)
	ON_BN_CLICKED(IDC_BTN_DEVSCAN, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnDevScan)
	ON_BN_CLICKED(IDC_BTN_APPLY, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnApply)
	ON_BN_CLICKED(IDC_BTN_GETDATA, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnGetdata)
	ON_BN_CLICKED(IDC_BTN_CLOSE, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnClose)
	ON_NOTIFY(NM_CLICK, IDC_LIST_DEVICE, &CNSERIESSDKUSBETHDlg::OnNMClickListDevice)
	ON_WM_DESTROY()
	ON_BN_CLICKED(IDC_BTN_DEVCLOSE, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnDevclose)
	ON_BN_CLICKED(IDC_CHK_AUTODARK, &CNSERIESSDKUSBETHDlg::OnBnClickedChkAutodark)
//	ON_EN_KILLFOCUS(IDC_EDIT_SELOUTTRGPIN, &CNSERIESSDKUSBETHDlg::OnEnKillfocusEditSelouttrgpin)
	ON_BN_CLICKED(IDC_BTN_EXTAPPLY, &CNSERIESSDKUSBETHDlg::OnBnClickedBtnExtapply)
END_MESSAGE_MAP()


BOOL CNSERIESSDKUSBETHDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != nullptr)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			
	SetIcon(m_hIcon, FALSE);		

	m_rbtrgNext.SetCheck(true);
	m_Dataname = _T("SDK_Data");
	m_dIntTime = 0;
	m_iTimeAve = 0;
	iSelectedListIndex = 0;
	ListControlSet();

	UpdateData(FALSE);
	return TRUE;  
}

void CNSERIESSDKUSBETHDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

void CNSERIESSDKUSBETHDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); 

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		// 아이콘을 그립니다.
		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

HCURSOR CNSERIESSDKUSBETHDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}

////// UI Update Function ////
void CNSERIESSDKUSBETHDlg::DeviceListViewUpdate()
{
	CString strNo;
	int iCount = m_Devicelist.GetItemCount();

	for (int i = iCount; i <sTotChnl; i++)
	{
		strNo.Format("%d", i);
		m_Devicelist.InsertItem(i, strNo);

		if (m_stDevList[i].sInterfaceType == SP_INTERFACE_ETHERNET)
		{
			m_Devicelist.SetItem(i, 1, LVIF_TEXT, "ETH", NULL, NULL, NULL, NULL);
			m_Devicelist.SetItem(i, 5, LVIF_TEXT, m_stDevList[i].cIPAddr, NULL, NULL, NULL, NULL);
		}
		else if(m_stDevList[i].sInterfaceType == SP_INTERFACE_USB)
			m_Devicelist.SetItem(i, 1, LVIF_TEXT, "USB", NULL, NULL, NULL, NULL);
		m_Devicelist.SetItem(i, 2, LVIF_TEXT, "X", NULL, NULL, NULL, NULL);
		m_Devicelist.SetItem(i, 3, LVIF_TEXT, m_stDevList[i].cModel, NULL, NULL, NULL, NULL);
		m_Devicelist.SetItem(i, 4, LVIF_TEXT, m_stDevList[i].cSerial, NULL, NULL, NULL, NULL);
	}
}

void CNSERIESSDKUSBETHDlg::AfterConnectCtrls()
{
	m_edIntTime.EnableWindow(TRUE);
	m_edTimeAve.EnableWindow(TRUE);
	m_btnApply.EnableWindow(TRUE);
	m_btnDevClose.EnableWindow(TRUE);

	m_rbtrgPrevious.EnableWindow(TRUE);
	m_rbtrgNext.EnableWindow(TRUE);
	m_rbtrgSW.EnableWindow(TRUE);
	m_rbtrgExternal.EnableWindow(TRUE);

	CString strCh;

	strCh.Format("%d", m_stDeviceInfo[iSelectedListIndex].sChannel);

	m_Devicelist.SetItem(iSelectedListIndex, 2, LVIF_TEXT, "O", NULL, NULL, NULL, NULL);
	m_Devicelist.SetItem(iSelectedListIndex, 6, LVIF_TEXT, strCh, NULL, NULL, NULL, NULL);
	UpdateData(FALSE);
}

void CNSERIESSDKUSBETHDlg::ListControlSet()
{
	CRect rt;
	m_Devicelist.GetWindowRect(&rt);
	m_Devicelist.SetExtendedStyle(LVS_EX_GRIDLINES | LVS_EX_FULLROWSELECT);
	m_Devicelist.InsertColumn(0, "No", LVCFMT_CENTER, rt.Width() * 0.06);
	m_Devicelist.InsertColumn(1, "Type", LVCFMT_CENTER, rt.Width() * 0.1);
	m_Devicelist.InsertColumn(2, "Use", LVCFMT_CENTER, rt.Width() * 0.08);
	m_Devicelist.InsertColumn(3, "Model", LVCFMT_CENTER, rt.Width() * 0.14);
	m_Devicelist.InsertColumn(4, "Serial", LVCFMT_CENTER, rt.Width() * 0.23);
	m_Devicelist.InsertColumn(5, "IP Address", LVCFMT_CENTER, rt.Width() * 0.25);
	m_Devicelist.InsertColumn(6, "Channel", LVCFMT_CENTER, rt.Width() * 0.14);
}

void CNSERIESSDKUSBETHDlg::DeactivateCtrls()
{
	m_edIntTime.EnableWindow(FALSE);
	m_edTimeAve.EnableWindow(FALSE);
	m_btnApply.EnableWindow(FALSE);
	m_btnConnect.EnableWindow(FALSE);
	m_btnGetdata.EnableWindow(FALSE);
	m_btnDevClose.EnableWindow(FALSE);

	m_rbtrgPrevious.EnableWindow(FALSE);
	m_rbtrgNext.EnableWindow(FALSE);
	m_rbtrgSW.EnableWindow(FALSE);
	m_rbtrgExternal.EnableWindow(FALSE);

	UpdateData(FALSE);
}

void CNSERIESSDKUSBETHDlg::BeforeScanDeviceCtrls()
{
	int iCount = m_Devicelist.GetItemCount();

	if (caTempConnectDevInfo.GetSize() > 0)
		caTempConnectDevInfo.RemoveAll();
	if (caTempConnectDevList.GetSize() > 0)
		caTempConnectDevList.RemoveAll();
	
	if ( iCount > 0)
	{
		for (int i = 0; i < m_Devicelist.GetItemCount(); i++)
		{
			if (m_Devicelist.GetItemText(i, 2) == "O")
			{
				bool bChk = false;

				bChk = spNCheckConnection(m_stDeviceInfo[i].sChannel);
				if (bChk)
				{
					caTempConnectDevList.Add(m_stDevList[i]);
					caTempConnectDevInfo.Add(m_stDeviceInfo[i]);
				}
				else
					spNDevClose(m_stDeviceInfo[i].sChannel);
			}
		}
	}
	
	m_Devicelist.DeleteAllItems();

	for (int i = 0; i < caTempConnectDevInfo.GetSize(); i++)
	{
		CString strNo;
		CString strChnl;
		strNo.Format("%d", i);
		m_Devicelist.InsertItem(i, strNo);

		if (caTempConnectDevInfo[i].sInterfaceType == SP_INTERFACE_ETHERNET)
		{
			m_Devicelist.SetItem(i, 1, LVIF_TEXT, "ETH", NULL, NULL, NULL, NULL);
			m_Devicelist.SetItem(i, 5, LVIF_TEXT, caTempConnectDevInfo[i].strIPAddr, NULL, NULL, NULL, NULL);
		}
		else if (caTempConnectDevInfo[i].sInterfaceType == SP_INTERFACE_USB)
			m_Devicelist.SetItem(i, 1, LVIF_TEXT, "USB", NULL, NULL, NULL, NULL);
		m_Devicelist.SetItem(i, 2, LVIF_TEXT, "O", NULL, NULL, NULL, NULL);
		m_Devicelist.SetItem(i, 3, LVIF_TEXT, caTempConnectDevInfo[i].strModel, NULL, NULL, NULL, NULL);
		m_Devicelist.SetItem(i, 4, LVIF_TEXT, caTempConnectDevInfo[i].strSerial, NULL, NULL, NULL, NULL);

		strChnl.Format("%d", caTempConnectDevInfo[i].sChannel);
		m_Devicelist.SetItem(i, 6, LVIF_TEXT,strChnl , NULL, NULL, NULL, NULL);
	}
}

void CNSERIESSDKUSBETHDlg::OnNMClickListDevice(NMHDR* pNMHDR, LRESULT* pResult)
{
	LPNMITEMACTIVATE pNMItemActivate = reinterpret_cast<LPNMITEMACTIVATE>(pNMHDR);
	*pResult = 0;
	if (pNMItemActivate->iItem >= 0)
	{
		iSelectedListIndex = pNMItemActivate->iItem;

		CString strUse = m_Devicelist.GetItemText(iSelectedListIndex, 2);

		if (strUse == "O")
		{			
			CString strModel;
			strModel.Format("%s", m_stDeviceInfo[iSelectedListIndex].strModel);
			if (strModel.Find("SM445") >= 0 || strModel.Find("SM642") >= 0)
				m_dIntTime = m_stDeviceInfo[iSelectedListIndex].iInttime / 1000.0;
			else
				m_dIntTime = m_stDeviceInfo[iSelectedListIndex].iInttime;
			m_iTimeAve = m_stDeviceInfo[iSelectedListIndex].iTimeavg;

			if (m_stDeviceInfo[iSelectedListIndex].sTrgMode == SP_TRIGGER_FREERUN_NEXT)
			{
				m_rbtrgNext.SetCheck(true);
				m_rbtrgPrevious.SetCheck(false);
				m_rbtrgSW.SetCheck(false);
				m_rbtrgExternal.SetCheck(false);
			}
			else if (m_stDeviceInfo[iSelectedListIndex].sTrgMode == SP_TRIGGER_FREERUN_PREV)
			{
				m_rbtrgNext.SetCheck(false);
				m_rbtrgPrevious.SetCheck(true);
				m_rbtrgSW.SetCheck(false);
				m_rbtrgExternal.SetCheck(false);
			}
			else if (m_stDeviceInfo[iSelectedListIndex].sTrgMode == SP_TRIGGER_SOFTWARE)
			{
				m_rbtrgNext.SetCheck(false);
				m_rbtrgPrevious.SetCheck(false);
				m_rbtrgSW.SetCheck(true);
				m_rbtrgExternal.SetCheck(false);
			}
			else if (m_stDeviceInfo[iSelectedListIndex].sTrgMode == SP_TRIGGER_EXTERNAL)
			{
				m_rbtrgNext.SetCheck(false);
				m_rbtrgPrevious.SetCheck(false);
				m_rbtrgSW.SetCheck(false);
				m_rbtrgExternal.SetCheck(true);
			}
			UpdateData(FALSE);
		}
	}
}
//////////////////////////////

////// Spectrometer Operation Event Function //////
void CNSERIESSDKUSBETHDlg::OnBnClickedBtnDevScan()
{
	BeforeScanDeviceCtrls();

	short sRtn;

	sRtn = spNScanDevice();
	if (sRtn < 0)
	{
		CString strLine;
		strLine.Format(_T("There are no matching devices. error = %d"), sRtn);
		AfxMessageBox(strLine);
		return;
	}
	
	int iCount = m_Devicelist.GetItemCount();

	m_stDevList = new _DevceList[sRtn + iCount];
	m_stDeviceInfo = new _DevInformation[sRtn + iCount];
	sTotChnl = sRtn + iCount;

	if (iCount > 0)
	{
		for (int i = 0; i < caTempConnectDevInfo.GetSize(); i++)
		{
			m_stDeviceInfo[i] = caTempConnectDevInfo.GetAt(i);
			m_stDevList[i] = caTempConnectDevList.GetAt(i);
		}
	}

	sRtn = spNGetDeviceList(m_stDevList + iCount);
	if (sRtn < 0)
	{
		CString strLine;
		strLine.Format(_T("Error Function : spNGetDeviceList(). error = %d"), sRtn);
		AfxMessageBox(strLine);
	}

	DeviceListViewUpdate();
	
	m_btnConnect.EnableWindow(TRUE);
	m_btnGetdata.EnableWindow(TRUE);
}

void CNSERIESSDKUSBETHDlg::OnBnClickedBtnConnect()
{
	if (m_Devicelist.GetSelectedCount() > 0)
	{
		short sSelChannel = iSelectedListIndex;
		short sRtn = - 1;
		if(m_stDevList[iSelectedListIndex].sInterfaceType == SP_INTERFACE_ETHERNET)
			sRtn = spNConnect(m_stDevList[iSelectedListIndex].sInterfaceType, m_stDevList[iSelectedListIndex].cIPAddr);
		else if(m_stDevList[iSelectedListIndex].sInterfaceType == SP_INTERFACE_USB)
			sRtn = spNConnect(m_stDevList[iSelectedListIndex].sInterfaceType, m_stDevList[iSelectedListIndex].cCOM);
		if (sRtn < 0)
		{
			CString strLine;

			if(sRtn == -116)
				strLine.Format(_T("Error Function : SPNConnect(). error = %d\nIt is already connected to another interface."), sRtn);
			else
				strLine.Format(_T("Error Function : SPNConnect(). error = %d"), sRtn);

			AfxMessageBox(strLine);
			return;
		}
				
		sRtn = spNGetDevParam(&m_stDeviceInfo[iSelectedListIndex],sRtn);
		if (sRtn < 0)
		{
			CString strLine;

			strLine.Format(_T("Error Function : spNGetDevParam(). error = %d"), sRtn);
			AfxMessageBox(strLine);
			return;
		}		
		
		if (m_stDeviceInfo[iSelectedListIndex].sCCDType == SP_CCD_TOSHIBA || m_stDeviceInfo[iSelectedListIndex].sCCDType == SP_CCD_S10420 || m_stDeviceInfo[iSelectedListIndex].sCCDType == SP_CCD_S10141)
			m_dIntTime = m_stDeviceInfo[iSelectedListIndex].iInttime/1000.0;
		else
			m_dIntTime = m_stDeviceInfo[iSelectedListIndex].iInttime;
		m_iTimeAve = m_stDeviceInfo[iSelectedListIndex].iTimeavg;
		
// 		sRtn = spNGetGainOffsetValue(&m_iGain, &m_iOffset, 0);
// 		if (sRtn < 0)
// 		{
// 			CString strLine;
// 			strLine.Format(_T("Error Function : spNGetGainOffsetValue(). error = %d"), sRtn);
// 			AfxMessageBox(strLine);
// 			return;
// 		}

		AfterConnectCtrls();
		sTotChnl++;
		UpdateData(FALSE);
	}
}

void CNSERIESSDKUSBETHDlg::OnBnClickedBtnApply()
{
	int sRtn;

	UpdateData();

	if (m_Devicelist.GetSelectedCount() > 0)
	{
		CString strModel;
		long lMaxIntTime = 65535;
		strModel.Format("%s", m_stDeviceInfo[iSelectedListIndex].strModel);		

		if (m_dIntTime == NULL || m_dIntTime < 0 || m_dIntTime > lMaxIntTime)
		{
			CString strMsg;

			if (strModel.Find("SM445") >= 0)
				strMsg.Format("Set a integration time between 0.01ms and %dms", lMaxIntTime);
			else
				strMsg.Format("Set a integration time between 1ms and %dms", lMaxIntTime);
			AfxMessageBox(strMsg);
			return;
		}
		if (m_iTimeAve == NULL || m_iTimeAve < 0)
		{
			AfxMessageBox("Time Average : Please enter an integer greater than 0.");
			return;
		}
		
		if (iSelectedListIndex >= 0)
		{	
			if (m_rbtrgNext.GetCheck())
				m_stDeviceInfo[iSelectedListIndex].sTrgMode = SP_TRIGGER_FREERUN_NEXT;
			else if (m_rbtrgPrevious.GetCheck())
				m_stDeviceInfo[iSelectedListIndex].sTrgMode = SP_TRIGGER_FREERUN_PREV;
			else if (m_rbtrgSW.GetCheck())
				m_stDeviceInfo[iSelectedListIndex].sTrgMode = SP_TRIGGER_SOFTWARE;
			else if (m_rbtrgExternal.GetCheck())
				m_stDeviceInfo[iSelectedListIndex].sTrgMode = SP_TRIGGER_EXTERNAL;

			if (strModel.Find("SM245") >= 0)
				sRtn = spNSetIntTime((long)m_dIntTime, m_stDeviceInfo[iSelectedListIndex].sChannel);				
			else
				sRtn = spNSetDBLIntTime(m_dIntTime, m_stDeviceInfo[iSelectedListIndex].sChannel);

			if (sRtn < 0)
			{
				CString strLine;
				strLine.Format(_T("Error Function : spNSetIntTime(). error = %d"), sRtn);
				AfxMessageBox(strLine);
				return;
			}

			sRtn = spNSetTimeAvg(m_stDeviceInfo[iSelectedListIndex].iTimeavg, m_stDeviceInfo[iSelectedListIndex].sChannel);
			if (sRtn < 0)
			{
				CString strLine;
				strLine.Format(_T("Error Function : spNSetTimeAvg(). error = %d"), sRtn);
				AfxMessageBox(strLine);
				return;
			}

			sRtn = spNSetTrgMode(m_stDeviceInfo[iSelectedListIndex].sTrgMode, m_stDeviceInfo[iSelectedListIndex].sChannel);
			if (sRtn < 0)
			{
				CString strLine;
				strLine.Format(_T("Error Function : spNSetTrgMode(). error = %d"), sRtn);
				AfxMessageBox(strLine);
				return;
			}

			if (strModel.Find("SM445") >= 0 || strModel.Find("SM642") >= 0)
				m_stDeviceInfo[iSelectedListIndex].iInttime = m_dIntTime * 1000;
			else
				m_stDeviceInfo[iSelectedListIndex].iInttime = m_dIntTime;
			m_stDeviceInfo[iSelectedListIndex].iTimeavg = m_iTimeAve;
		}
	}
}

void CNSERIESSDKUSBETHDlg::OnBnClickedBtnGetdata()
{
	CString strFile;
	CStdioFile sioFile;
	CString strSave;
	short sRtn;
	
	UpdateData();

	if (iSelectedListIndex >= 0)
	{
		long* plArrayData = new long[m_stDeviceInfo[iSelectedListIndex].iTotPixelNum];
		ZeroMemory(plArrayData, sizeof(long) * m_stDeviceInfo[iSelectedListIndex].iTotPixelNum);

		if (m_bRunOutTrg)
			sRtn = spNReadDataExOutTrg(plArrayData, m_stDeviceInfo[iSelectedListIndex].sChannel);
		else
			sRtn = spNReadDataEx(plArrayData, m_stDeviceInfo[iSelectedListIndex].sChannel);
		if (sRtn < 0)
		{
			CString strLine;
			strLine.Format(_T("Error Function : spNReadDataEx(). error = %d"), sRtn);
			AfxMessageBox(strLine);
			return;
		}
		CString filename,strSerial;

		GetDlgItemText(IDC_EDIT_DATANAME, filename);
		strSerial.Format(_T("-%s"), m_stDeviceInfo[iSelectedListIndex].strSerial);
		strFile.Format(_T("%s%s.txt"), filename, strSerial);

		// File Open
		sioFile.Open(strFile, CFile::modeCreate | CFile::modeWrite);

		// Save data
		strSave.Format(_T("Pixel\tWavelength(nm)\tIntensity\n"));
		sioFile.WriteString(strSave);

		for (int i = 0; i < m_stDeviceInfo[iSelectedListIndex].iRealPixelNum; i++) {
			strSave.Format(_T("%5d\t%5.2f\t%d\n"), i + 1, m_stDeviceInfo[iSelectedListIndex].dWLTable[i], plArrayData[m_stDeviceInfo[iSelectedListIndex].iDummyPixelNum + i]);
			sioFile.WriteString(strSave);
		}

		sioFile.Close();
	}
}

void CNSERIESSDKUSBETHDlg::OnBnClickedChkAutodark()
{
	UpdateData();

	short sRtn;

	if (m_bAutoDark)
		sRtn = spNAutoDark(1, m_stDeviceInfo[iSelectedListIndex].sChannel);
	else
		sRtn = spNAutoDark(0, m_stDeviceInfo[iSelectedListIndex].sChannel);
	
	if (sRtn < 0)
	{
		CString strLine;
		strLine.Format(_T("Error Function : spNAutoDark(). error = %d"), sRtn);
		AfxMessageBox(strLine);
	}
}

void CNSERIESSDKUSBETHDlg::OnBnClickedBtnExtapply()
{
	short sRtn;

	UpdateData();

	sRtn = spNSetOutTrgPin(m_sSelOutTrgPin, m_stDeviceInfo[iSelectedListIndex].sChannel);
	if (sRtn < 0)
	{
		CString strLine;
		strLine.Format(_T("Error Function : spNSetOutTrgPin(). error = %d"), sRtn);
		AfxMessageBox(strLine);
	}
}


void CNSERIESSDKUSBETHDlg::OnBnClickedBtnClose()
{
	for (int i = 0; i < sTotChnl; i++)
	{
		if (m_Devicelist.GetItemText(i, 2) == "O")
			spNDevClose(m_stDeviceInfo[i].sChannel);
	}

	::SendMessage(this->m_hWnd, WM_CLOSE, NULL, NULL);
}

void CNSERIESSDKUSBETHDlg::OnBnClickedBtnDevclose()
{
	if (iSelectedListIndex >= 0)
	{
		if (m_Devicelist.GetItemText(iSelectedListIndex, 2) == "O")
		{
			spNDevClose(m_stDeviceInfo[iSelectedListIndex].sChannel);
			m_Devicelist.SetItem(iSelectedListIndex, 2, LVIF_TEXT, (LPCTSTR)"X", NULL, NULL, NULL, NULL);
			m_Devicelist.SetItem(iSelectedListIndex, 6, LVIF_TEXT, (LPCTSTR)"", NULL, NULL, NULL, NULL);
			sTotChnl--;
		}
	}
}

void CNSERIESSDKUSBETHDlg::OnDestroy()
{
	CDialogEx::OnDestroy();
	for (int i = 0; i < sTotChnl; i++)
	{
		if (m_Devicelist.GetItemText(i, 2) == "O")
			spNDevClose(m_stDeviceInfo[i].sChannel);
	}			
}



///////////////////////////////////////////////////






