/*
 *  Spectral Products (c)
 *  SM642 Linux-USB Install Program
 *  Raspberry Pi3

 *  Author : Ko Seok Hyun
 *  Date   : 2019. 3. 4
 *  Version : 1.1.4
                                                                                              
 INSTALLING and USING: Raspberry Pi3

INSTALLING and USING:
1) install libusb-1.0.x 
   (sudo apt-get install libusb-1.0)
2) mkdir /home/(user_dir)/SM642
3) copy SDK_SM642.tar to /home/(user_dir)/SM642
4) tair -xvf SDK_SM642.tar
5) type ./sm642install or manually copy files :
    (1) 88-spusb-smSerise.rules to /etc/udev/rules.d directory
    (2) SM642.hex to /lib/firmware directory
    (3) check SM642 hotplugging to linux system
       ("tail -f /var/log/syslog")
    (4) connect SM642
    (5) check device (Vid:04B4  Pid:0242)
       ("lsusb")

6) gcc -o sdksm642 sdksm642.c -L. -lSPdbUSBLinux -lm -lusb-1.0
7) ./sdksm642
8) test SM642 

*/
                                                                                              
#include <stdio.h>
#include <signal.h>

void twait();

int main()
{
	system("clear");
	printf("\n\n\n");
	printf("         **************************************************************\n");
	printf("         *      Spectral Products Install Program Ver 1.1.4           *\n");
	printf("         *      SM642 Linux          Install Program                  *\n");
	printf("         *      Raspbery Pi3				                          *\n");
	printf("         **************************************************************\n");
	printf("\n\n\n");
	
	printf("Install SM642 Program for Raspbery Pi3"); 
	twait();

	system("cp 88-spusb-smSerise.rules /etc/udev/rules.d");
	printf("Copy  Rules file to  /etc/udev/rules.d");
	twait();
	system("cp SM642HS.hex /lib/firmware");
	printf("Copy Hexfile to /lib/firmware");
	twait();
	system("cp SM642.conf /etc");
	printf("Copy SM642.conf to /etc");
	twait();
	printf("\n\n\n");
}

void twait()
{
	sleep(1);printf("      .............................  OK\n\n");
}



