/*
 *  Spectral Products (c)
 *  SM440 Linux-USB Install Program
 *  Raspberry Pi3

 *  Author : Ko Seok Hyun
 *  Date   : 2019. 3. 4
 *  Version : 1.1.4

 INSTALLING and USING: Raspberry Pi3

INSTALLING and USING:
1) install libusb-1.0.x 
   (sudo apt-get install libusb-1.0)
2) mkdir /home/(user_dir)/SM440
3) copy SDK_SM440.tar to /home/(user_dir)/SM440
4) tair -xvf SDK_SM440.tar
5) type ./sm440install or manually copy files :
    (1) 88-spusb-smSerise.rules to /etc/udev/rules.d directory
    (2) SM440.hex to /lib/firmware directory
    (3) check SM440 hotplugging to linux system
       ("tail -f /var/log/syslog")
    (4) connect SM440
    (5) check device (Vid:04B4  Pid:2791)
       ("lsusb")

6) gcc -o sdksm440 sdksm440.c -L. -lSPdbUSBLinux -lm -lusb-1.0
7) ./sdksm440
8) test SM440 

*/
                                                                                              
#include <stdio.h>
#include <signal.h>

void twait();

int main()
{
	system("clear");
	printf("\n\n\n");
	printf("         **************************************************************\n");
	printf("         *      Spectral Products Install Program Ver 1.1.4           *\n");
	printf("         *      SM440 Linux          Install Program                  *\n");
	printf("         *      Raspbery Pi3							              *\n");
	printf("         **************************************************************\n");
	printf("\n\n\n");
	
	printf("Install SM440 Program for  Raspbery Pi3"); 
	twait();

	system("cp 88-spusb-smSerise.rules /etc/udev/rules.d");
	printf("Copy  Rules file to  /etc/udev/rules.d");
	twait();
	system("cp SM440.hex /lib/firmware");
	printf("Copy Hexfile to /lib/firmware");
	twait();
	system("cp SM440.conf /etc");
	printf("Copy SM440.conf to /etc");
	twait();
	printf("\n\n\n");
}

void twait()
{
	sleep(1);printf("      .................................  OK\n\n");
}



