// DlgChnlAssign.cpp : implementation file
//

#include "stdafx.h"
#include "SDK_USBm_SM304.h"
#include "DlgChnlAssign.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgChnlAssign dialog


CDlgChnlAssign::CDlgChnlAssign(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgChnlAssign::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgChnlAssign)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}


void CDlgChnlAssign::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgChnlAssign)
	DDX_Control(pDX, IDC_BTN_UPDATE, m_btnUpdate);
	DDX_Control(pDX, IDC_CB_NEWCHANNEL, m_cbNewChnl);
	DDX_Control(pDX, IDC_CB_CURCHANNEL, m_cbCurChnl);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDlgChnlAssign, CDialog)
	//{{AFX_MSG_MAP(CDlgChnlAssign)
	ON_BN_CLICKED(IDC_BTN_CHANGE, OnBtnChange)
	ON_BN_CLICKED(IDC_BTN_UPDATE, OnBtnUpdate)
	ON_CBN_SELCHANGE(IDC_CB_CURCHANNEL, OnSelchangeCbCurChannel)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgChnlAssign message handlers

BOOL CDlgChnlAssign::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: Add extra initialization here
	//// Define the ComboBox size ////
	CRect rt;
	// Current Channel combo box
	m_cbCurChnl.GetWindowRect(&rt);
	ScreenToClient(&rt);
	rt.bottom = rt.top + rt.Height()*3;
	m_cbCurChnl.MoveWindow(rt);
	// New Channel combo box
	m_cbNewChnl.GetWindowRect(&rt);
	ScreenToClient(&rt);
	rt.bottom = rt.top + rt.Height()*3;
	m_cbNewChnl.MoveWindow(rt);

	//// Add strings into each combo box ////
	int i;
	CString str;
	// Reset
	m_cbCurChnl.ResetContent();
	m_cbNewChnl.ResetContent();
	// Add channel IDs
	for(i=0 ; i<m_sTotChnlNum ; i++){
		str.Format(_T("%d"), (int)m_asChnIDs[i]);
		m_cbCurChnl.AddString(str);
	}
	m_cbCurChnl.SetCurSel(0);
	for(i=0 ; i<MAX_USB_PORT_NUM ; i++){
		str.Format(_T("%d"), i);
		m_cbNewChnl.AddString(str);
	}
	m_cbNewChnl.SetCurSel(m_asChnIDs[0]);
	// Disable the Update button at first
	m_btnUpdate.EnableWindow(FALSE);

	m_bIsChanged = false;	// There is no change yet.
	UpdateData(FALSE);
	return TRUE;  // return TRUE unless you set the focus to a control
	              // EXCEPTION: OCX Property Pages should return FALSE
}

void CDlgChnlAssign::OnBtnChange() 
{
	// TODO: Add your control notification handler code here
	UpdateData();
	short sRtn;
	short sCurChnlID, sNewChnlID;
	int nNewId, nCurId;
	CString strChnl;

	// Get the new channel ID
	nNewId = m_cbNewChnl.GetCurSel();
	m_cbNewChnl.GetLBText(nNewId, strChnl);
	sNewChnlID = (short)atoi((LPCSTR)strChnl);
	// Get the current channel ID
	nCurId = m_cbCurChnl.GetCurSel();
	m_cbCurChnl.GetLBText(nCurId, strChnl);
	sCurChnlID = (short)atoi((LPCSTR)strChnl);

	// If the new ID is the same and the current ID, it doesn't need to run spWriteChannelID().
	if(sCurChnlID == sNewChnlID)	return;

	// sp DLL function use ; write channel ID
	sRtn = spWriteChannelID(sNewChnlID, sCurChnlID);
	if(sRtn < 0)
	{	// Error in communication via the USB port
		strChnl.Format(_T("There is an error on changing the channel ID of the channel# %d."), (int)sCurChnlID);
		AfxMessageBox(strChnl);
		m_btnUpdate.EnableWindow(FALSE);
		return;
	}
	m_asChnIDs[nCurId] = sNewChnlID;
	m_bIsChanged = true;
	// Activate the Update button
	m_btnUpdate.EnableWindow();
}

void CDlgChnlAssign::OnBtnUpdate() 
{	// Update the current channel ID combo box contents
	// TODO: Add your control notification handler code here
	m_cbCurChnl.ResetContent();
	// Add channel IDs
	CString str;
	for(short i=0 ; i<m_sTotChnlNum ; i++){
		str.Format(_T("%d"), (int)m_asChnIDs[i]);
		m_cbCurChnl.AddString(str);
	}
	m_cbCurChnl.SetCurSel(0);

	m_btnUpdate.EnableWindow(FALSE);

	UpdateData(FALSE);
}

void CDlgChnlAssign::OnSelchangeCbCurChannel() 
{	// Select current channel
	// TODO: Add your control notification handler code here
	UpdateData();

	int nIdPort = m_cbCurChnl.GetCurSel();	// nIdPort is the current USB port number
	int nIdChnl = (int)m_asChnIDs[nIdPort];	// nIdChnl is the new channel number

	m_cbNewChnl.SetCurSel(nIdChnl);	// Show the channel number assigned

	UpdateData(FALSE);
}
