// SPdbUSBmDLL.h
/////////////////////
#ifndef __SPDBUSBMDLL_H__
#define __SPDBUSBMDLL_H__

#define DLLIMPORT extern "C" __declspec(dllimport)
#define	CALLTYPE	__stdcall

#define MAX_USB_PORT_NUM	8
#define SP_EXT_TRG_WAITING	-99

enum{
	SP_ORDER_BY_USBPORTNUM	= 0,
	SP_ORDER_BY_CHANNELID	= 1
};

enum{
	SP_TRIGGER_OFF		= 10,
	SP_TRIGGER_INTERNAL = 11,
	SP_TRIGGER_EXTERNAL = 12
};

enum{
	SP_NO_ERROR					=  1,
	SP_ERROR_DEVICE_IO_CTRL		= -1,
	SP_ERROR_OPEN_DRIVER		= -2,
	SP_ERROR_OPEN_FILE			= -3,
	SP_ERROR_EEPROM_READ		= -4,
	SP_ERROR_MEMORY_ALLOC		= -5
};

enum{
	SP_CCD_SONY					= 0,
	SP_CCD_TOSHIBA				= 1,
	SP_CCD_PDA					= 2,	// Back thinned CCD
	SP_CCD_S10420				= 4,		//Non Cooled BT Back thinned CCD
	SP_CCD_G92XX_512			= 3,		// InGaAs
	SP_CCD_G92XX_256			= 5,		// InGaAs
	SP_CCD_S10141				= 6,		//SM303 S10141 CCD
	SP_CCD_TCD1304AP			= 7			//SM445
};

///////////////////// TEMPORARY SETTING VALUE ///////////////////////////
#define SP_TEMP_SM303G 999
/////////////////////////////////////////////////////////////////////////

enum{
	SP_CCD_PIXEL_PDA			= 1056,	// Back thinned CCD
	SP_CCD_PIXEL_PDA_REAL		= 1024,
	SP_CCD_PIXEL_SONY			= 2080,
	SP_CCD_PIXEL_SONY_REAL		= 2048,
	SP_CCD_PIXEL_TOSHIBA		= 3680,
	SP_CCD_PIXEL_TOSHIBA_REAL	= 3648,
	SP_CCD_PIXEL_G92XX_512		= 512,
	SP_CCD_PIXEL_G92XX_512_REAL	= 512,
	SP_CCD_PIXEL_G92XX_256		= 256,
	SP_CCD_PIXEL_G92XX_256_REAL = 256,
	SP_CCD_PIXEL_S10141			= 2080, 
	SP_CCD_PIXEL_S10141_REAL	= 2048,
	SP_CCD_PIXEL_TCD1304AP		= 3680,
	SP_CCD_PIXEL_TCD1304AP_REAL = 3648
};

DLLIMPORT short CALLTYPE spTestAllChannels(short sOrderType = SP_ORDER_BY_CHANNELID);
DLLIMPORT short CALLTYPE spSetupAllChannels();
DLLIMPORT short CALLTYPE spSetupGivenChannel(short sChannel=0);
DLLIMPORT short CALLTYPE spInitAllChannels(short sCCDType = SP_CCD_SONY);
DLLIMPORT short CALLTYPE spInitGivenChannel(short sCCDType = SP_CCD_SONY, short sChannel = 0);
DLLIMPORT short CALLTYPE spSetDblIntEx(double const dIntTime, short sChannel=0);
DLLIMPORT short CALLTYPE spSetIntEx(long const lIntTime, short sChannel=0);
DLLIMPORT short CALLTYPE spSetTrgEx(short const sTrgType, short sChannel=0);
DLLIMPORT short CALLTYPE spReadDataEx(long *lpArray, short sChannel=0);
DLLIMPORT short CALLTYPE spCloseAllChannels();
DLLIMPORT short CALLTYPE spCloseGivenChannel(short sChannel=0);
DLLIMPORT short CALLTYPE spWriteChannelID(short sNum, short sChannel=0);
DLLIMPORT short CALLTYPE spReadChannelID(short *spNum, short sChannel=0);
DLLIMPORT void CALLTYPE spGetAssignedChannelID(short *spChannelID);
DLLIMPORT void CALLTYPE spPolyCalc(double *coefs, short order, double x, double *y);
DLLIMPORT short CALLTYPE spPolyFit(double *x, double *y, short numPts, double *coefs, short order);
DLLIMPORT short CALLTYPE spReadEEPROM(char *cpStr, short sChannel=0);
DLLIMPORT short CALLTYPE spWriteEEPROM(char *cpStr, short sChannel=0);
DLLIMPORT LPCTSTR CALLTYPE spGetEEPROMData();
DLLIMPORT void CALLTYPE spSetEEPROMData(LPCTSTR pStr);
DLLIMPORT short CALLTYPE spSelectCF(long lCF, short sChannel=0);
DLLIMPORT short CALLTYPE spSetTEC(long lTEC, short nChannel=0);
DLLIMPORT short CALLTYPE spReadDataAdvEx(long *lpArray, short sTimeAve=1, short usFFTMax = 0, short sBadPxlNum=0, short *spBad=NULL, short sChannel=0);

#endif
