/*
 *  Spectral Products (c)
 *  SM303 Linux-USB Install Program
 *  Raspberry Pi3

 *  Author : Ko Seok Hyun
 *  Date   : 2019. 3. 4 
 *  Version : 1.1.4
                                                                                              
 INSTALLING and USING: Raspberry Pi3

INSTALLING and USING:
1) install libusb-1.0.x 
   (sudo apt-get install libusb-1.0)
2) mkdir /home/(user_dir)/SM303
3) copy SDK_SM303.tar to /home/(user_dir)/sm303
4) tair -xvf SDK_SM303.tar
5) type ./sm303install or manually copy files :
    (1) 88-spusb-smSerise.rules to /etc/udev/rules.d directory
    (2) SM303Si.hex to /lib/firmware directory
    (3) check SM303 hotplugging to linux system
       ("tail -f /var/log/syslog")
    (4) connect SM303
    (5) check device (Vid:0547  Pid:0322)
       ("lsusb")

6) gcc -o sdksm303 sdksm303.c -L. -lSPdbUSBLinux -lm -lusb-1.0
7) ./sdksm303
8) test SM303 

*/
                                                                                              
#include <stdio.h>
#include <signal.h>

void twait();

int main()
{
	system("clear");
	printf("\n\n\n");
	printf("         **************************************************************\n");
	printf("         *      Spectral Products Install Program Ver 1.1.4           *\n");
	printf("         *      SM303 Linux          Install Program                  *\n");
	printf("         *      Raspbery Pi3				                          *\n");
	printf("         **************************************************************\n");
	printf("\n\n\n");
	
	printf("Install SM303 Program for Raspbery Pi3"); 
	twait();

	system("cp 88-spusb-smSerise.rules /etc/udev/rules.d");
	printf("Copy  Rules file to  /etc/udev/rules.d");
	twait();
	system("cp SM303Si.hex /lib/firmware");
	printf("Copy Hexfile to /lib/firmware");
	twait();
	system("cp SM303Si.conf /etc");
	printf("Copy SM3032Si.conf to /etc");
	twait();
	printf("\n\n\n");
}

void twait()
{
	sleep(1);printf("      .............................  OK\n\n");
}



