
#include <libusb-1.0/libusb.h>  

#define RETURN_SUCCESS	1
#define RETURN_FAIL	0
#define SP_EXT_TRG_WAITING	-99

enum{
	SP_TRIGGER_OFF			=		10,
	SP_TRIGGER_INTERNAL		=		11,
	SP_TRIGGER_EXTERNAL		=		12
};

enum{
	SP_INTERNAL_SWTRIGGER		= 		0,
	SP_INTERNAL_FREERUN_PREV	=		1,
	SP_INTERNAL_FREERUN_NEXT	=		2,
	SP_EXTERNAL_EDGE_FALLING	=		0,
	SP_EXTERNAL_EDGE_RISING		=		1
};

enum{
	SP_CCD_PIXEL_G92XX_256		= 256,	// InGaAs
	SP_CCD_PIXEL_G92XX_256_REAL	= 256,
	SP_CCD_PIXEL_G9212			= 512,	// InGaAs
	SP_CCD_PIXEL_G9212_REAL		= 512,
	SP_CCD_PIXEL_PDA			= 1056,	// Back thinned CCD, it has to be a multiple of "32"
	SP_CCD_PIXEL_PDA_REAL		= 1024,
	SP_CCD_PIXEL_SONY			= 2080,
	SP_CCD_PIXEL_SONY_REAL		= 2048,
	SP_CCD_PIXEL_TOSHIBA		= 3680,
	SP_CCD_PIXEL_TOSHIBA_REAL	= 3648,
	SP_CCD_PIXEL_S10420			= 2080,	// Non Cooled Back thined
	SP_CCD_PIXEL_S10420_REAL	= 2048
};

enum{
	SP_CCD_SONY				=		0,
	SP_CCD_TOSHIBA			=		1,
	SP_CCD_PDA				=		2,	// Back thinned CCD
	SP_CCD_G9212			=		3,	// InGaAs
	SP_CCD_S10420			=		4,	//Non Cooled BT Back thinned CCD
	SP_CCD_G92XX_256		=		5
};

extern short spFindDevice();
extern short spSetIntEx(long lIntTime,short sChannel);
extern short spSetDblIntEx(double dintegration_time,short sChannel);
extern short spReadDataEx(unsigned long * pt_cell_arry,short sChannel);
extern short spCloseDevice(void);
extern short spDeviceInitialize();
extern void spPolyCalc(double *coefs, short order, double x, double *y);
extern short spPolyFit(double *x, double *y, short numPts, double *coefs, short order);
extern short spGetWLTable(double *WLTable, short sChannel);
extern short spDevInfo(char *strModel, char *strSerial, short sChannel);
extern short spGetModel(short sChannel);

extern short spSetTrgEx(short const sTrgType, short sChannel);
extern short spSetIntMode(short nReadExMode, const double dIntTime, short sChannel);
extern short spSetExtEdgeMode(short nExtTriggerMode, short sChannel);

extern short spInsShutter(short sChannel);
extern short spSetShutterPos(short sShutter, short sChannel);
extern short spGetShutterPos(short sChannel);

extern short spSetTec(long lTEC, short sChannel);