/*
 *  Spectral Products (c)
 *  SM304 Linux-USB Install Program
 *  Raspberry Pi3

 *  Author : Ko Seok Hyun
 *  Date   : 2019. 3. 4
 *  Version : 1.1.4
                                                                                              
 INSTALLING and USING: Raspberry Pi3

INSTALLING and USING:
1) install libusb-1.0.x 
   (sudo apt-get install libusb-1.0)
2) mkdir /home/(user_dir)/SM304
3) copy SDK_SM304.tar to /home/(user_dir)/sm304
4) tair -xvf SDK_SM304.tar
5) type ./sm304install or manually copy files :
    (1) 88-spusb-smSerise.rules to /etc/udev/rules.d directory
    (2) hex file to /lib/firmware directory
	   - SM304_G9204-512.hex,SM304_G9206-256.hex,SM304_G9206-512.hex
	     SM304_G9208-256.hex,SM304_G9208-512.hex
    (3) check SM304 hotplugging to linux system
       ("tail -f /var/log/syslog")
    (4) connect SM304
    (5) check device (Vid:04B4  Pid:0237)
       ("lsusb")

6) gcc -o sdksm304 sdksm304.c -L. -lSPdbUSBLinux -lm -lusb-1.0
7) ./sdksm304
8) test SM304 

*/
                                                                                              
#include <stdio.h>
#include <signal.h>

void twait();

int main()
{
	system("clear");
	printf("\n\n\n");
	printf("         **************************************************************\n");
	printf("         *      Spectral Products Install Program Ver 1.1.4           *\n");
	printf("         *      SM304 Linux          Install Program                  *\n");
	printf("         *      Raspbery Pi3				                          *\n");
	printf("         **************************************************************\n");
	printf("\n\n\n");
	
	printf("Install SM304 Program for Raspbery Pi3"); 
	twait();

	system("cp 88-spusb-smSerise.rules /etc/udev/rules.d");
	printf("Copy  Rules file to  /etc/udev/rules.d");
	twait();
	system("cp SM304_G9204-512.hex /lib/firmware");
	system("cp SM304_G9206-256.hex /lib/firmware");
	system("cp SM304_G9206-512.hex /lib/firmware");
	system("cp SM304_G9208-256.hex /lib/firmware");
	system("cp SM304_G9208-512.hex /lib/firmware");
	printf("Copy .Hex file to /lib/firmware");
	twait();
	system("cp SM304_G9204-512.conf /etc");
	system("cp SM304_G9206-256.conf /etc");
	system("cp SM304_G9206-512.conf /etc");
	system("cp SM304_G9208-256.conf /etc");
	system("cp SM304_G9208-512.conf /etc");
	printf("Copy .conf file to /etc");
	twait();
	printf("\n\n\n");
}

void twait()
{
	sleep(1);printf("      .............................  OK\n\n");
}



