

#include "stdafx.h"
#include "SDK_NonlinearityCorrection.h"
#include "SDK_NonlinearityCorrectionDlg.h"
#include "afxdialogex.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#endif

class CAboutDlg : public CDialogEx
{
public:
	CAboutDlg();

	enum { IDD = IDD_ABOUTBOX };

	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    

protected:
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialogEx(CAboutDlg::IDD)
{
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialogEx)
END_MESSAGE_MAP()


CSDK_NonlinearityCorrectionDlg::CSDK_NonlinearityCorrectionDlg(CWnd* pParent /*=NULL*/)
	: CDialogEx(CSDK_NonlinearityCorrectionDlg::IDD, pParent)
	, m_lIntTime(0)
	, m_strInform(_T(""))
	, m_sTimeAvge(0)
{
	m_hIcon = AfxGetApp()->LoadIcon(IDR_MAINFRAME);
}

void CSDK_NonlinearityCorrectionDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Text(pDX, IDC_EDIT_INTTIME, m_lIntTime);
	DDV_MinMaxLong(pDX, m_lIntTime, 1, 65535);
	DDX_Text(pDX, IDC_STATIC_INFORM, m_strInform);
	DDX_Control(pDX, IDC_BTN_START, m_btnStart);
	DDX_Control(pDX, IDC_BTN_STOP, m_btnStop);
	DDX_Text(pDX, IDC_EDIT_AVGTIME, m_sTimeAvge);
	DDV_MinMaxLong(pDX, m_sTimeAvge, 1, 1000);
}

BEGIN_MESSAGE_MAP(CSDK_NonlinearityCorrectionDlg, CDialogEx)
	ON_WM_SYSCOMMAND()
	ON_WM_PAINT()
	ON_WM_QUERYDRAGICON()
	ON_BN_CLICKED(IDC_BTN_DEVCON, &CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnDevcon)
	ON_BN_CLICKED(IDC_BTN_INTSET, &CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnIntset)
	ON_BN_CLICKED(IDC_BTN_START, &CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnStart)
	ON_BN_CLICKED(IDC_BTN_STOP, &CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnStop)
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_BTN_DARK, &CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnDark)
END_MESSAGE_MAP()


BOOL CSDK_NonlinearityCorrectionDlg::OnInitDialog()
{
	CDialogEx::OnInitDialog();

	ASSERT((IDM_ABOUTBOX & 0xFFF0) == IDM_ABOUTBOX);
	ASSERT(IDM_ABOUTBOX < 0xF000);

	CMenu* pSysMenu = GetSystemMenu(FALSE);
	if (pSysMenu != NULL)
	{
		BOOL bNameValid;
		CString strAboutMenu;
		bNameValid = strAboutMenu.LoadString(IDS_ABOUTBOX);
		ASSERT(bNameValid);
		if (!strAboutMenu.IsEmpty())
		{
			pSysMenu->AppendMenu(MF_SEPARATOR);
			pSysMenu->AppendMenu(MF_STRING, IDM_ABOUTBOX, strAboutMenu);
		}
	}

	SetIcon(m_hIcon, TRUE);			
	SetIcon(m_hIcon, FALSE);		

	OnBnClickedBtnDevcon();
	return TRUE;  
}

void CSDK_NonlinearityCorrectionDlg::OnSysCommand(UINT nID, LPARAM lParam)
{
	if ((nID & 0xFFF0) == IDM_ABOUTBOX)
	{
		CAboutDlg dlgAbout;
		dlgAbout.DoModal();
	}
	else
	{
		CDialogEx::OnSysCommand(nID, lParam);
	}
}

void CSDK_NonlinearityCorrectionDlg::OnPaint()
{
	if (IsIconic())
	{
		CPaintDC dc(this); 

		SendMessage(WM_ICONERASEBKGND, reinterpret_cast<WPARAM>(dc.GetSafeHdc()), 0);

		int cxIcon = GetSystemMetrics(SM_CXICON);
		int cyIcon = GetSystemMetrics(SM_CYICON);
		CRect rect;
		GetClientRect(&rect);
		int x = (rect.Width() - cxIcon + 1) / 2;
		int y = (rect.Height() - cyIcon + 1) / 2;

		dc.DrawIcon(x, y, m_hIcon);
	}
	else
	{
		CDialogEx::OnPaint();
	}
}

HCURSOR CSDK_NonlinearityCorrectionDlg::OnQueryDragIcon()
{
	return static_cast<HCURSOR>(m_hIcon);
}


void CSDK_NonlinearityCorrectionDlg::DrawGraph()
{
	CClientDC dc(GetDlgItem(IDC_PC_GRAPH));

	CRect rect;
	GetDlgItem(IDC_PC_GRAPH)->GetClientRect(&rect);

	CDC memDC;
	CBitmap *pOldBitMap,bitmap;
	CPen *pOldPen,pen;
	CFont *pOldfont,font;

	memDC.CreateCompatibleDC(&dc);
	bitmap.CreateCompatibleBitmap(&dc,rect.Width(),rect.Height());
	pOldBitMap = memDC.SelectObject(&bitmap);

	pen.CreatePen(PS_SOLID,1,RGB(119,119,119));
	pOldPen = memDC.SelectObject(&pen);

	font.CreatePointFont(80,_T("Arial"));
	pOldfont = memDC.SelectObject(&font);

	memDC.Rectangle(rect);

	memDC.SelectObject(pOldPen);
	pen.DeleteObject();

	pen.CreatePen(PS_SOLID,1,RGB(0,0,0));
	pOldPen = memDC.SelectObject(&pen);
	
	double dPointXLength,dPointYLength;

	dPointXLength = (rect.Width()/10)*9 - (rect.Width()/10+10);
	dPointYLength = (rect.Height()/10)*9 - (rect.Height()/10);

	dYRate = dPointYLength/65535;
	dXRate = dPointXLength/sRealPixel;

	memDC.MoveTo(rect.Width()/10+10,rect.Height()/10);
	memDC.LineTo(rect.Width()/10+10,(rect.Height()/10)*9);
	memDC.LineTo((rect.Width()/10)*9,(rect.Height()/10)*9);

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9);
	memDC.LineTo(rect.Width()/10+5,(rect.Height()/10)*9);
	memDC.TextOutW(rect.Width()/10 - 5 ,(rect.Height()/10)*9 - 7,_T("0"));

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 16383*dYRate);
	memDC.LineTo(rect.Width()/10+5,(rect.Height()/10)*9 - 16383*dYRate);
	memDC.TextOutW(rect.Width()/10 - 30,(rect.Height()/10)*9 - 16383*dYRate - 7,_T("16383"));

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 32766*dYRate);
	memDC.LineTo(rect.Width()/10+5,(rect.Height()/10)*9 - 32766*dYRate);
	memDC.TextOutW(rect.Width()/10 - 30,(rect.Height()/10)*9 - 32766*dYRate - 7,_T("32766"));

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 49149*dYRate);
	memDC.LineTo(rect.Width()/10+5,(rect.Height()/10)*9 - 49149*dYRate);
	memDC.TextOutW(rect.Width()/10 - 30,(rect.Height()/10)*9 - 49149*dYRate - 7,_T("49149"));

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 65535*dYRate);
	memDC.LineTo(rect.Width()/10+5,(rect.Height()/10)*9 - 65535*dYRate);
	memDC.TextOutW(rect.Width()/10 - 30,(rect.Height()/10)*9 - 65535*dYRate - 7,_T("65535"));

	CString strTemp;
	int iIndex;

	for(int i = 0 ; i < 5 ; i++)
	{
		iIndex = (sRealPixel/4) * i;
		if(i != 0 ) iIndex --;

		memDC.MoveTo(rect.Width()/10+10 + iIndex*dXRate,(rect.Height()/10)*9);
		memDC.LineTo(rect.Width()/10+10 + iIndex*dXRate,(rect.Height()/10)*9 + 5);					
		
		strTemp.Format(_T("%.1f"),dWLTable[iIndex]);
		memDC.TextOutW(rect.Width()/10+ 1 + iIndex*dXRate,(rect.Height()/10)*9 + 7,strTemp);
	}

	memDC.SelectObject(pOldPen);
	pen.DeleteObject();

	pen.CreatePen(PS_SOLID,1,RGB(187,187,187));
	pOldPen = memDC.SelectObject(&pen);
	
	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 16383*dYRate);
	memDC.LineTo((rect.Width()/10)*9,(rect.Height()/10)*9 - 16383*dYRate);

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 32766*dYRate);
	memDC.LineTo((rect.Width()/10)*9,(rect.Height()/10)*9 - 32766*dYRate);

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 49149*dYRate);
	memDC.LineTo((rect.Width()/10)*9,(rect.Height()/10)*9 - 49149*dYRate);

	memDC.MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - 65535*dYRate);
	memDC.LineTo((rect.Width()/10)*9,(rect.Height()/10)*9 - 65535*dYRate);

	for(int i = 1 ; i < 5 ; i++)
	{
		iIndex = (sRealPixel/4) * i;
		if(i != 0 ) iIndex --;

		memDC.MoveTo(rect.Width()/10+10 + iIndex*dXRate,(rect.Height()/10)*9);
		memDC.LineTo(rect.Width()/10+10 + iIndex*dXRate,rect.Height()/10);	
	}

	if(!m_bStop)
		DrawPlotData(&memDC,rect);

	dc.BitBlt(0,0,rect.Width(),rect.Height(),&memDC,0,0,SRCCOPY);
	memDC.SelectObject(pOldPen);
	pen.DeleteObject();	
	memDC.DeleteDC();
}

void CSDK_NonlinearityCorrectionDlg::DrawPlotData(CDC *pDC, CRect rect)
{
	CPen *pOldPen, pen;

	pen.CreatePen(PS_SOLID,1,RGB(255,0,0));
	pOldPen = pDC->SelectObject(&pen);

	for(int i = 0 ; i < sRealPixel; i++)
	{
		if(i == 0)
			pDC->MoveTo(rect.Width()/10+10,(rect.Height()/10)*9 - lArrayData[i+sOpicalBlk]*dYRate);
		else
			pDC->LineTo(rect.Width()/10+10 + i*dXRate,(rect.Height()/10)*9 - lArrayData[i+sOpicalBlk]*dYRate);
	}

	pDC->SelectObject(pOldPen);
	pen.DeleteObject();
}

UINT CSDK_NonlinearityCorrectionDlg::GetDataThread(LPVOID pParam)
{
	CSDK_NonlinearityCorrectionDlg *App = (CSDK_NonlinearityCorrectionDlg*)pParam;
	short sRtn;

	while(!App->m_bStop)
	{
		sRtn = spReadNLCDataEx(App->lArrayData,App->m_sTimeAvge,0);
		//sRtn = spReadDataEx(App->lArrayData,0);
		if(sRtn == -11)
		{
			AfxMessageBox(_T("Not Support Nonlinearity Correction."));
			break;
		}
		else if(sRtn == -12)
		{
			AfxMessageBox(_T("Dark Scan Error.\nNeed to Dark Data Measure(spReadDarkData)."));
		}
		else if(sRtn < 0)
			break;

		App->DrawGraph();
	}

	App->m_bStop = true;
	App->m_pThread = NULL;
	return 0;
}

void CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnDevcon()
{
	short sRtn;

	sRtn = spTestAllChannels(0);	// Check the total number of USB ports connected
	if(sRtn < 0)
	{
		m_strInform = "Not Find Device";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	}

	sCCDType = spGetModel(0);
	if(sCCDType == SP_CCD_SONY)
	{
		sTotPixel = SP_CCD_PIXEL_SONY;
		sRealPixel = SP_CCD_PIXEL_SONY_REAL;
		sOpicalBlk = 32;		
	}
	else if(sCCDType == SP_CCD_TOSHIBA)
	{
		sTotPixel = SP_CCD_PIXEL_TOSHIBA;
		sRealPixel = SP_CCD_PIXEL_TOSHIBA_REAL;
		sOpicalBlk = 32;
	}
	else if(sCCDType == SP_CCD_PDA)
	{
		sTotPixel = SP_CCD_PIXEL_PDA;
		sRealPixel = SP_CCD_PIXEL_PDA_REAL;
		sOpicalBlk = 10;
	}
	else if(sCCDType == SP_CCD_G9212)
	{
		sTotPixel = SP_CCD_PIXEL_G9212;
		sRealPixel = SP_CCD_PIXEL_G9212_REAL;
		sOpicalBlk = 0;
	}
	else if(sCCDType == SP_CCD_S10420)
	{
		sTotPixel = SP_CCD_PIXEL_S10420;
		sRealPixel = SP_CCD_PIXEL_S10420_REAL;
		sOpicalBlk = 10;
	}
	else if(sCCDType == SP_CCD_S10141)
	{
		sTotPixel = SP_CCD_PIXEL_S10141;
		sRealPixel = SP_CCD_PIXEL_S10141_REAL;
		sOpicalBlk = 10;
	}
	else if(sCCDType == SP_CCD_TCD1304AP)
	{
		sTotPixel = SP_CCD_PIXEL_TCD1304AP;
		sRealPixel = SP_CCD_PIXEL_TCD1304AP_REAL;
		sOpicalBlk = 32;
	}

	dWLTable = new double[sRealPixel];
	lArrayData = new long[sTotPixel];

	sRtn = spSetupAllChannels();
	if(sRtn < 0)
	{
		m_strInform = "Fail spSetupAllChannels";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	}

	sRtn = spInitAllChannels(sCCDType);
	if(sRtn < 0)
	{
		m_strInform = "Fail spInitAllChannels";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	}

	sRtn = spSetTrgEx(SP_TRIGGER_INTERNAL,0);
	if(sRtn < 0)
	{
		m_strInform = "Fail spInitAllChannels";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	}

	m_lIntTime = 35;
	m_sTimeAvge = 1;
	sRtn = spSetIntEx(m_lIntTime,0);
	if(sRtn < 0)
	{
		m_strInform = "Fail spInitAllChannels";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	} 

	char strSerial[20], strModel[20];

	sRtn = spDevInfo(strModel,strSerial);
	if(sRtn < 0)
	{
		m_strInform = "Fail spDevInfo";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	}

	sRtn = spGetWLTable(dWLTable,0);
	if(sRtn < 0)
	{
		m_strInform = "Fail spGetWLTable";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	}

	if(sCCDType == SP_CCD_PDA || sCCDType == SP_CCD_S10141 || sCCDType == SP_CCD_G9212)
	{
		sRtn = spSetTEC(1,0);
		if(sRtn < 0)
		{
			m_strInform = "Fail spSetTEC";
			m_btnStart.EnableWindow(FALSE);
			UpdateData(FALSE);
			return;
		}

		sRtn = spSelectCF(1,0);
		if(sRtn < 0)
		{
			m_strInform = "Fail spSelectCF";
			m_btnStart.EnableWindow(FALSE);
			UpdateData(FALSE);
			return;
		}

	}

	CString strTemp;

	DrawGraph();
	m_strInform.Format(_T("Medel : %s\nSerial : %s"),(CString)strModel,(CString)strSerial);
	m_btnStart.EnableWindow(FALSE);
	UpdateData(FALSE);
}


void CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnIntset()
{
	UpdateData();
	short sRtn;

	sRtn = spSetIntEx(m_lIntTime,0);
	if(sRtn < 0)
	{
		m_strInform = "Fail spInitAllChannels";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
		return;
	} 
}


void CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnStart()
{
	if(m_pThread == NULL)
	{
		m_pThread = AfxBeginThread(GetDataThread,this);
		hThread = m_pThread->m_hThread;
		m_bStop = false;
	}
}


void CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnStop()
{
	m_bStop = true;
	m_pThread = NULL;
}


void CSDK_NonlinearityCorrectionDlg::OnClose()
{
	delete[] lArrayData;
	delete[] dWLTable;

	CDialogEx::OnClose();
}


void CSDK_NonlinearityCorrectionDlg::OnBnClickedBtnDark()
{
	short sRtn;
	long *lDarkData;

	lDarkData = new long[sTotPixel];

	sRtn = spReadDark(lDarkData,m_sTimeAvge,0);
	if(sRtn < 0)
	{
		m_strInform = "Fail spReadDark";
		m_btnStart.EnableWindow(FALSE);
		UpdateData(FALSE);
	}

	m_btnStart.EnableWindow(TRUE);
}
