/*
 *  Spectral Products (c)
 *  SM245 Linux-USB Install Program
 *  Raspberry Pi3

 *  Author : Ko Seok Hyun
 *  Date   : 2019. 3. 4 
 *  Version : 1.1.4
                                                                                              
 INSTALLING and USING: Raspberry Pi3

INSTALLING and USING:
1) install libusb-1.0.x 
   (sudo apt-get install libusb-1.0)
2) mkdir /home/(user_dir)/SM245
3) copy SDK_SM245.tar to /home/(user_dir)/SM245
4) tair -xvf SDK_SM245.tar
5) type ./sm245install or manually copy files :
    (1) 88-spusb-smSerise.rules to /etc/udev/rules.d directory
    (2) SM245.hex to /lib/firmware directory
    (3) check SM245 hotplugging to linux system
       ("tail -f /var/log/syslog")
    (4) connect SM245
    (5) check device (Vid:04B4  Pid:0237)
       ("lsusb")

6) gcc -o sdksm245 sdksm245.c -L. -lSPdbUSBLinux -lm -lusb-1.0
7) ./sdksm245
8) test SM245 

*/
                                                                                              
#include <stdio.h>
#include <signal.h>

void twait();

int main()
{
	system("clear");
	printf("\n\n\n");
	printf("         **************************************************************\n");
	printf("         *      Spectral Products Install Program Ver 1.1.4           *\n");
	printf("         *      SM245 Linux          Install Program                  *\n");
	printf("         *      Raspbery Pi3							              *\n");
	printf("         **************************************************************\n");
	printf("\n\n\n");
	
	printf("Install SM245 Program for Raspbery Pi3"); 
	twait();

	system("cp 88-spusb-smSerise.rules /etc/udev/rules.d");
	printf("Copy  Rules file to  /etc/udev/rules.d");
	twait();
	system("cp SM245.hex /lib/firmware");
	printf("Copy Hexfile to /lib/firmware");
	twait();
	system("cp SM245.conf /etc");
	printf("Copy SM245.conf to /etc");
	twait();
	printf("\n\n\n");
}

void twait()
{
	sleep(1);printf("      .............................  OK\n\n");
}



