classdef SPETHlibrary
    properties
        bInitial = zeros(1,10)
        sTotChnl = 0   
        sDevType = zeros(1,10)
        strModel = strings(1,10)
        lIntTime = zeros(1,10)
        sTotPixelNum = zeros(1,10)
        sRealPixelNum = zeros(1,10)
        sStartOpticalBlank = zeros(1,10)
        sAvgTime = zeros(1,10)
        sTrgMode = zeros(1,10)
        sIntMode = zeros(1,10)
        sExtMode = zeros(1,10)                     
        stDevList
        stDevParam        
    end
    
    methods        
        function LoadLibrary(~)
            if not(libisloaded('SPdbEthm'))
               loadlibrary('SPdbEthm.dll')               
            end
            
        end
         
        function unLoadLibrary(~)
            if (libisloaded('SPdbEthm'))
               unloadlibrary SPdbEthm           
            end
        end
        
        function result = NConnect(~,sInterfaceType,cConnectAddr)
           result = calllib('SPdbEthm','spNConnect',sInterfaceType,cConnectAddr);            
        end
        
        function result = NDevInfo(~,cModel, cSerial, sInterfaceType, sChannel)
           result = calllib('SPdbEthm','NDevInfo',cModel,cSerial,sInterfaceType,sChannel);            
        end
        
        function result = NGetCCDType(~, sCCDType, sChannel)
           result = calllib('SPdbEthm','spNGetCCDType',sCCDType,sChannel);            
        end
        
        function result = NGetEEPROM(~, pcEEPData, sChannel)
           result = calllib('SPdbEthm','spNGetEEPROM',pcEEPData,sChannel);            
        end
        
        function result = NSetIntTime(~,lIntTime, sChannel)
           result = calllib('SPdbEthm','spNSetIntTime',lIntTime,sChannel);            
        end
        
        function result = NSetTimeAvg(~,sAvgTime, sChannel)
           result = calllib('SPdbEthm','spNSetTimeAvg',sAvgTime,sChannel);            
        end
        
        function result = NSetTrgMode(~,sTrgMode, sChannel)
           result = calllib('SPdbEthm','spNSetTrgMode',sTrgMode,sChannel);            
        end
        
        function result = NSetDevice(~,lIntTime, sAverage, sTrgMode, sChannel)
           result = calllib('SPdbEthm','spNSetDevice',lIntTime,sAverage,sTrgMode,sChannel);            
        end
        
        function result = NGetWLTable(~,dWLTable,sChannel)
           result = calllib('SPdbEthm','spNGetWLTable',dWLTable,sChannel);            
        end
        
        function result = NReadDataEx(~,lpArray,sChannel)
           result = calllib('SPdbEthm','spNReadDataEx',lpArray,sChannel);            
        end
        
        function result = NGetNETInfo(~, pcIPAddr,  pcMACAddr, sNetModel, sChannel)
           result = calllib('SPdbEthm','spNGetNETInfo',pcIPAddr,pcMACAddr,sNetModel,sChannel);            
        end
        
        function result = NCheckConnection(~,sChannel)
           result = calllib('SPdbEthm','spNCheckConnection',sChannel);            
        end
        
        function result = NPolyCalc(~,ceofs,order,x,y)
           result = calllib('SPdbEthm','spNPolyCalc',ceofs,order,x,y);            
        end
               
        function result = NPolyFit(~,x,y,numPts,coefs,order)
           result = calllib('SPdbEthm','spNPolyFit',x,y,numPts,coefs,order);            
        end      
        
        function result = NScanDevice(~,sScanMode)
           result = calllib('SPdbEthm','spNScanDevice',sScanMode);            
        end
        
        function result = NGetDeviceList(~,DevList)
           result = calllib('SPdbEthm','spNGetDeviceList',DevList);            
        end
        
       function result = NGetDevParam(~, pDevInfo,sChannel)
           result = calllib('SPdbEthm','spNGetDevParam',pDevInfo,sChannel);            
        end
        
        function result = NDevClose(~,sChannel)
           result = calllib('SPdbEthm','spNDevClose',sChannel);            
        end        
    end
end

